/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.inventories.InternalInventory;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3917;

public class WirelessAccessPointMenu
extends AEBaseMenu
implements InternalInventoryHost {
    public static final class_3917<WirelessAccessPointMenu> TYPE = MenuTypeBuilder.create(WirelessAccessPointMenu::new, WirelessAccessPointBlockEntity.class).build("wireless_access_point");
    private final WirelessAccessPointBlockEntity accessPoint;
    private final RestrictedInputSlot boosterSlot;
    private final RestrictedInputSlot linkableIn;
    private final OutputSlot linkableOut;
    @GuiSync(value=1)
    public long range = 0L;
    @GuiSync(value=2)
    public long drain = 0L;

    public WirelessAccessPointMenu(int id, class_1661 ip, WirelessAccessPointBlockEntity host) {
        super(TYPE, id, ip, host);
        this.accessPoint = host;
        this.boosterSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.RANGE_BOOSTER, host.getInternalInventory(), 0);
        this.addSlot(this.boosterSlot, SlotSemantics.STORAGE);
        this.boosterSlot.setEmptyTooltip(() -> Tooltips.slotTooltip(ButtonToolTips.PlaceWirelessBooster.text()));
        AppEngInternalInventory gridLinkingInv = new AppEngInternalInventory(this, 2);
        this.linkableIn = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.GRID_LINKABLE_ITEM, gridLinkingInv, 0);
        this.addSlot(this.linkableIn, SlotSemantics.MACHINE_INPUT);
        this.linkableIn.setEmptyTooltip(() -> Tooltips.slotTooltip(ButtonToolTips.LinkWirelessTerminal.text()));
        this.linkableOut = new OutputSlot(gridLinkingInv, 1, null);
        this.addSlot(this.linkableOut, SlotSemantics.MACHINE_OUTPUT);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void method_7623() {
        int boosters = this.boosterSlot.method_7677().method_7960() ? 0 : this.boosterSlot.method_7677().method_7947();
        this.setRange((long)(10.0 * AEConfig.instance().wireless_getMaxRange(boosters)));
        this.setDrain((long)(100.0 * AEConfig.instance().wireless_getPowerDrain(boosters)));
        super.method_7623();
    }

    public long getRange() {
        return this.range;
    }

    private void setRange(long range) {
        this.range = range;
    }

    public long getDrain() {
        return this.drain;
    }

    private void setDrain(long drain) {
        this.drain = drain;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.linkableIn.method_7681()) {
            player.method_7328(this.linkableIn.method_7677(), false);
        }
        if (this.linkableOut.method_7681()) {
            player.method_7328(this.linkableOut.method_7677(), false);
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        class_1799 term;
        IGridLinkableHandler handler;
        if (!this.linkableOut.method_7681() && this.linkableIn.method_7681() && (handler = GridLinkables.get((class_1935)(term = this.linkableIn.method_7677().method_7972()).method_7909())) != null && handler.canLink(term)) {
            handler.link(term, this.accessPoint.getGlobalPos());
            this.linkableIn.method_7673(class_1799.field_8037);
            this.linkableOut.method_7673(term);
        }
    }
}

